/*
 * Decompiled with CFR 0.152.
 */
package common.ui;

import common.ui.DisplaySizes;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class UiComponent {
    protected final DisplaySizes displaySize;
    protected int width = 0;
    protected int height = 0;
    protected int xPos = 0;
    protected int yPos = 0;
    protected String label = null;
    protected Font font = null;
    protected int backgroundColor = -1;
    protected Image backgroundImage = null;
    protected boolean highlighted = false;
    protected boolean drawHighlightRectangle = false;
    protected boolean rightToLeft = false;

    public UiComponent(DisplaySizes displaySize) {
        this.displaySize = displaySize;
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        if (this.backgroundColor != -1) {
            g.setColor(this.backgroundColor);
            g.fillRect(this.xPos, this.yPos, this.width, this.height);
        }
    }

    public void repaint() {
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void keyPressed(int keyCode, int gameAction) {
    }

    public DisplaySizes getDisplaySize() {
        return this.displaySize;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setXPos(int xPos) {
        this.xPos = xPos;
    }

    public int getXPos() {
        return this.xPos;
    }

    public void setYPos(int yPos) {
        this.yPos = yPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setDrawHighlightRectangle(boolean drawHighlightRectangle) {
        this.drawHighlightRectangle = drawHighlightRectangle;
    }

    public boolean isDrawHighlightRectangle() {
        return this.drawHighlightRectangle;
    }

    public void setRightToLeft(boolean rightToLeft) {
        this.rightToLeft = rightToLeft;
    }

    public boolean isRightToLeft() {
        return this.rightToLeft;
    }
}

